/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import io.wispforest.owo.ui.util.Delta;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import rearth.oracle.Oracle;
import rearth.oracle.ui.OracleScreen;
import rearth.oracle.util.MarkdownParser;

public final class OracleClient {
    public static final class_304 ORACLE_WIKI = new class_304("key.oracle_index.open", 72, "key.categories.misc");
    public static final Set<String> LOADED_BOOKS = new HashSet<String>();
    public static final HashMap<class_2960, BookItemLink> ITEM_LINKS = new HashMap();
    public static class_1799 tooltipStack;
    public static float openEntryProgress;

    public static void init() {
        Oracle.LOGGER.info("Hello from the Oracle Wiki Client!");
        KeyMappingRegistry.register((class_304)ORACLE_WIKI);
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (ORACLE_WIKI.method_1436()) {
                Oracle.LOGGER.info("Opening Oracle Wiki...");
                client.method_1507((class_437)new OracleScreen());
            }
        });
        ClientLifecycleEvent.CLIENT_STARTED.register(client -> {
            Oracle.LOGGER.info("Indexing entry items...");
            OracleClient.findAllResourceEntries();
        });
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (class_437.method_25443()) {
                return;
            }
            openEntryProgress += Delta.compute((float)openEntryProgress, (float)0.0f, (float)0.13f);
        });
    }

    public static void openScreen(@Nullable String bookId, @Nullable class_2960 entryId, @Nullable class_437 parent) {
        if (bookId != null) {
            OracleScreen.activeBook = bookId;
        }
        if (entryId != null) {
            OracleScreen.activeEntry = entryId;
        }
        class_310.method_1551().method_1507((class_437)new OracleScreen(parent));
    }

    private static void findAllResourceEntries() {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        Map resources = resourceManager.method_14488("books", path -> path.method_12832().endsWith(".mdx"));
        LOADED_BOOKS.clear();
        for (class_2960 resourceId : resources.keySet()) {
            String purePath = resourceId.method_12832().replaceFirst("books/", "");
            String[] segments = purePath.split("/");
            String modId = segments[0];
            String entryPath = purePath.replaceFirst(modId + "/", "");
            String entryFileName = segments[segments.length - 1];
            String entryDirectory = entryPath.replace(entryFileName, "");
            try {
                String fileContent = new String(((class_3298)resources.get(resourceId)).method_14482().readAllBytes(), StandardCharsets.UTF_8);
                Map<String, String> fileComponents = MarkdownParser.parseFrontmatter(fileContent);
                if (fileComponents.containsKey("related_items")) {
                    String[] itemStrings;
                    String baseString = fileComponents.get("related_items").replace("[", "").replace("]", "");
                    for (String itemString : itemStrings = baseString.split(", ")) {
                        class_2960 itemId = class_2960.method_60654((String)itemString);
                        BookItemLink linkData = new BookItemLink(resourceId, fileComponents.getOrDefault("title", "missing"), modId);
                        ITEM_LINKS.put(itemId, linkData);
                    }
                }
            }
            catch (IOException e) {
                Oracle.LOGGER.error("Unable to load book with id: " + String.valueOf(resourceId));
                throw new RuntimeException(e);
            }
            LOADED_BOOKS.add(modId);
        }
    }

    static {
        openEntryProgress = 0.0f;
    }

    public record BookItemLink(class_2960 linkTarget, String entryName, String bookId) {
    }
}

